package gov.va.vinci.dart.db;

import java.util.List;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.biz.EventType;
import gov.va.vinci.dart.service.DartObjectFactory;

public class TestEventTypeDAO extends BusinessIntegrationTest {
	
	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}
	
	@Test
	public void testOne() throws Exception {
		try {
			DartObjectFactory.getInstance().getEventTypeDAO().findById(-1);
			Assert.fail("Expected ObjectNotFoundException");
		}
		catch (ObjectNotFoundException e) {}
		
		List<EventType> dtList = DartObjectFactory.getInstance().getEventTypeDAO().listAll();
		Assert.assertNotNull(dtList);
		Assert.assertTrue(dtList.size() > 0);
	}

	@Test
	public void testTwo() throws Exception {
		
		List<EventType> etList = DartObjectFactory.getInstance().getEventTypeDAO().listAll();
		Assert.assertNotNull(etList);
		Assert.assertTrue(etList.size() > 0);
		
		EventType et = etList.get(0);
		Assert.assertNotNull(et);
		Assert.assertTrue(et.getId() > 0);
		
		EventType et2 = DartObjectFactory.getInstance().getEventTypeDAO().findById(et.getId());
		Assert.assertNotNull(et2);
		Assert.assertEquals(et2, et);
	}

}
